---
title: Rewrite path of archived blog posts · Cloudflare Rules docs
description: Create a URL rewrite rule (part of Transform Rules) to rewrite any
  requests for `/news/2012/...` URI paths to `/archive/news/2012/...`.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: URL rewrite
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/rewrite-path-archived-posts/
  md: https://developers.cloudflare.com/rules/transform/examples/rewrite-path-archived-posts/index.md
---

To rewrite all requests to `/news/2012/...` to `/archive/news/2012/...` you must add a reference to the content of the original URL. Create a new URL rewrite rule and define a dynamic URL path rewrite using [wildcard pattern parameters](https://developers.cloudflare.com/rules/transform/url-rewrite/create-dashboard/#wildcard-pattern-parameters):

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `https://<YOUR_HOSTNAME>/news/2012/*`

**Then rewrite the path and/or query**

* **Target path**: \[`/`] `news/2012/*`
* **Rewrite to**: \[`/`] `archive/news/2012/${1}`

Make sure to replace `<YOUR_HOSTNAME>` with your actual hostname and adjust the example paths according to your setup.
