---
title: Functions · Cloudflare Pages docs
description: Pages Functions allows you to build full-stack applications by
  executing code on the Cloudflare network with Cloudflare Workers. With
  Functions, you can introduce application aspects such as authenticating,
  handling form submissions, or working with middleware. Workers runtime
  features are configurable on Pages Functions, including compatibility with a
  subset of Node.js APIs and the ability to set a compatibility date or
  compatibility flag. Use Functions to deploy server-side code to enable dynamic
  functionality without running a dedicated server.
lastUpdated: 2025-09-15T21:45:20.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/pages/functions/
  md: https://developers.cloudflare.com/pages/functions/index.md
---

Pages Functions allows you to build full-stack applications by executing code on the Cloudflare network with [Cloudflare Workers](https://developers.cloudflare.com/workers/). With Functions, you can introduce application aspects such as authenticating, handling form submissions, or working with middleware. [Workers runtime features](https://developers.cloudflare.com/workers/runtime-apis/) are configurable on Pages Functions, including [compatibility with a subset of Node.js APIs](https://developers.cloudflare.com/workers/runtime-apis/nodejs) and the ability to set a [compatibility date or compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-dates/). Use Functions to deploy server-side code to enable dynamic functionality without running a dedicated server.

To provide feedback or ask questions on Functions, join the [Cloudflare Developers Discord](https://discord.com/invite/cloudflaredev) and connect with the Cloudflare team in the [#functions channel](https://discord.com/channels/595317990191398933/910978223968518144).

* [Get started](https://developers.cloudflare.com/pages/functions/get-started/)
* [Routing](https://developers.cloudflare.com/pages/functions/routing/)
* [API reference](https://developers.cloudflare.com/pages/functions/api-reference/)
* [Examples](https://developers.cloudflare.com/pages/functions/examples/)
* [Middleware](https://developers.cloudflare.com/pages/functions/middleware/)
* [Configuration](https://developers.cloudflare.com/pages/functions/wrangler-configuration/)
* [Local development](https://developers.cloudflare.com/pages/functions/local-development/)
* [Bindings](https://developers.cloudflare.com/pages/functions/bindings/)
* [TypeScript](https://developers.cloudflare.com/pages/functions/typescript/)
* [Advanced mode](https://developers.cloudflare.com/pages/functions/advanced-mode/)
* [Metrics](https://developers.cloudflare.com/pages/functions/metrics/)
* [Debugging and logging](https://developers.cloudflare.com/pages/functions/debugging-and-logging/)
* [Smart Placement](https://developers.cloudflare.com/pages/functions/smart-placement/)
* [Pages Plugins](https://developers.cloudflare.com/pages/functions/plugins/)
* [Pricing](https://developers.cloudflare.com/pages/functions/pricing/)
* [Module support](https://developers.cloudflare.com/pages/functions/module-support/)
* [Source maps and stack traces](https://developers.cloudflare.com/pages/functions/source-maps/)
