---
title: Network-layer DDoS Attack Protection managed ruleset · Cloudflare DDoS
  Protection docs
description: The Cloudflare Network-layer DDoS Attack Protection managed ruleset
  is a set of pre-configured rules used to match known DDoS attack vectors at
  levels 3 and 4 of the OSI model.
lastUpdated: 2025-06-30T19:31:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/
  md: https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/index.md
---

The Cloudflare Network-layer DDoS Attack Protection managed ruleset is a set of pre-configured rules used to match [known DDoS attack vectors](https://developers.cloudflare.com/ddos-protection/about/attack-coverage/) at levels 3 and 4 of the OSI model.

Cloudflare updates the list of rules in the managed ruleset on a regular basis. Refer to the [changelog](https://developers.cloudflare.com/ddos-protection/change-log/network/) for more information on recent and upcoming changes.

The Network-layer DDoS Attack Protection managed ruleset is always enabled — you can only customize its behavior.

## Ruleset configuration

You may need to adjust the behavior of specific rules in case of false positives or due to specific traffic patterns.

Adjust the behavior of the rules in the managed ruleset by modifying the following parameters:

* The performed **action** when an attack is detected
* The **sensitivity level** of attack detection mechanisms

To adjust rule behavior, use one of the following methods:

* [Configure the managed ruleset in the Cloudflare dashboard](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/configure-dashboard/).
* [Configure the managed ruleset via Cloudflare API](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/configure-api/).
* [Configure the managed ruleset using Terraform](https://developers.cloudflare.com/terraform/additional-configurations/ddos-managed-rulesets/#example-configure-network-layer-ddos-attack-protection).

You can only configure the behavior of the managed ruleset to set a stronger mitigation action or a lower sensitivity. Refer to [Managed ruleset parameters](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/override-parameters/) for more information.

Overrides can apply to all packets or to a subset of incoming packets, depending on the override expression. Refer to [Override expressions](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/network-overrides/override-expressions/) for more information.

## Availability

The Network-layer DDoS Attack Protection managed ruleset is available in all Cloudflare plans for:

* Zones [onboarded to Cloudflare](https://developers.cloudflare.com/dns/zone-setups/full-setup/) (zones with their traffic routed through the Cloudflare network)
* IP applications onboarded to [Spectrum](https://developers.cloudflare.com/spectrum/)
* IP prefixes onboarded to [Magic Transit](https://developers.cloudflare.com/magic-transit/)

However, only Magic Transit and Spectrum customers on an Enterprise plan can customize the managed ruleset.

## Related Cloudflare products

Magic Transit customers can configure the following additional products:

* Enable [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) to detect and mitigate sophisticated out-of-state TCP attacks such as randomized and spoofed ACK floods or SYN and SYN-ACK floods.
* Create custom [Magic Firewall](https://developers.cloudflare.com/magic-firewall/) rules to block additional network-layer attacks.

Spectrum customers can use [IP Access](https://developers.cloudflare.com/waf/tools/ip-access-rules/) rules to block additional network-layer attacks.
