---
title: Metadata filtering and multitenancy support in AutoRAG · Changelog
description: Add metadata filters to AutoRAG queries to enable multitenancy and
  control the scope of retrieved results.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-23-autorag-metadata-filtering/
  md: https://developers.cloudflare.com/changelog/2025-04-23-autorag-metadata-filtering/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Metadata filtering and multitenancy support in AutoRAG

Apr 23, 2025

[AI Search](https://developers.cloudflare.com/ai-search/)

You can now filter [AutoRAG](https://developers.cloudflare.com/ai-search/) search results by `folder` and `timestamp` using [metadata filtering](https://developers.cloudflare.com/ai-search/configuration/metadata) to narrow down the scope of your query.

This makes it easy to build [multitenant experiences](https://developers.cloudflare.com/ai-search/how-to/multitenancy/) where each user can only access their own data. By organizing your content into per-tenant folders and applying a `folder` filter at query time, you ensure that each tenant retrieves only their own documents.

**Example folder structure:**

```bash
customer-a/logs/
customer-a/contracts/
customer-b/contracts/
```

**Example query:**

```js
const response = await env.AI.autorag("my-autorag").search({
  query: "When did I sign my agreement contract?",
  filters: {
    type: "eq",
    key: "folder",
    value: "customer-a/contracts/",
  },
});
```

You can use metadata filtering by creating a new AutoRAG or reindexing existing data. To reindex all content in an existing AutoRAG, update any chunking setting and select **Sync index**. Metadata filtering is available for all data indexed on or after **April 21, 2025**.

If you are new to AutoRAG, get started with the [Get started AutoRAG guide](https://developers.cloudflare.com/ai-search/get-started/).
