---
title: Smart Placement is smarter about running Workers and Pages Functions in
  the best locations · Changelog
description: Workers and Pages Functions with Smart Placement enabled will not
  unexpectedly return to default locations if request traffic dips.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-22-smart-placement-stablization/
  md: https://developers.cloudflare.com/changelog/2025-03-22-smart-placement-stablization/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Smart Placement is smarter about running Workers and Pages Functions in the best locations

Mar 22, 2025

[Workers ](https://developers.cloudflare.com/workers/)[Pages](https://developers.cloudflare.com/pages/)

[Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement/) is a unique Cloudflare feature that can make decisions to move your Worker to run in a more optimal location (such as closer to a database). Instead of always running in the default location (the one closest to where the request is received), Smart Placement uses certain “heuristics” (rules and thresholds) to decide if a different location might be faster or more efficient.

Previously, if these heuristics weren't consistently met, your Worker would revert to running in the default location—even after it had been optimally placed. This meant that if your Worker received minimal traffic for a period of time, the system would reset to the default location, rather than remaining in the optimal one.

Now, once Smart Placement has identified and assigned an optimal location, temporarily dropping below the heuristic thresholds will not force a return to default locations. For example in the previous algorithm, a drop in requests for a few days might return to default locations and heuristics would have to be met again. This was problematic for workloads that made requests to a geographically located resource every few days or longer. In this scenario, your Worker would never get placed optimally. This is no longer the case.
