---
title: Scraping detections · Cloudflare bot solutions docs
description: Scraping behavioral detection IDs allow you to better protect your
  website from volumetric scraping attacks by identifying anomalous behavior.
  The detection IDs below are specifically designed to catch suspicious scraping
  activity at the zone level.
lastUpdated: 2025-11-05T15:19:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/additional-configurations/detection-ids/scraping-detections/
  md: https://developers.cloudflare.com/bots/additional-configurations/detection-ids/scraping-detections/index.md
---

Scraping behavioral detection IDs allow you to better protect your website from volumetric scraping attacks by identifying anomalous behavior. The detection IDs below are specifically designed to catch suspicious scraping activity at the zone level.

| Detection ID | Description |
| - | - |
| `50331648` | Observes patterns of requests sent to your zone, dynamically analyzing behavior by ASN. |
| `50331649` | Observes patterns of requests sent to your zone, dynamically analyzing behavior by JA4 fingerprint. |

## Challenges for scraping detections

Cloudflare's [Managed Challenge](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/#managed-challenge-recommended) can limit scraping attacks on your website.

To access scraping detections:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.
  2. Go to **Security** > **WAF**.
  3. Under **Custom rules**, select **Create rule**.
  4. Fill out the form using **Bot Detection IDs** along with other necessary information.
  5. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. Select **Create rule** and choose **Custom rule**.

  3. Fill out the form using **Bot Detection IDs** along with other necessary information.

  4. Select **Save as draft** to return to the rule later, or **Deploy** to deploy the rule.

```js
(any(cf.bot_management.detection_ids[*] in {50331648 50331649}) and not cf.bot_management.verified_bot)
```

Best practice

If you are choosing to challenge as your rule action, ensure that you exclude any API calls on which you do not want to issue a challenge. To exclude requests to such paths, edit the [WAF custom rule](https://developers.cloudflare.com/waf/custom-rules/) to exclude the relevant paths.

Note

The matched traffic for detection IDs `50331648` and `50331649` is dynamically re-calculated, meaning a single fingerprint would not be permanently flagged unless it continues to behave suspiciously at all times.
