---
title: Set up 1.1.1.1 on Google Cloud · Cloudflare 1.1.1.1 docs
description: Google Cloud supports configuring outbound server policy within
  Cloud DNS. Policies are applied per Virtual Private Cloud (VPC) network, and
  will affect all resources within that VPC network, including any existing
  virtual machines.
lastUpdated: 2025-10-22T21:11:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/1.1.1.1/setup/google-cloud/
  md: https://developers.cloudflare.com/1.1.1.1/setup/google-cloud/index.md
---

Google Cloud supports configuring [outbound server policy](https://cloud.google.com/dns/docs/server-policies-overview#dns-server-policy-out) within Cloud DNS. Policies are applied per Virtual Private Cloud (VPC) network, and will affect all resources within that VPC network, including any existing virtual machines.

Note

If you are using [Cloudflare Zero Trust](https://developers.cloudflare.com/cloudflare-one/), you can choose assigned [locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/) to apply custom [DNS policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/dns-policies/) via Gateway.

To configure 1.1.1.1 for your Google Cloud VPC network(s):

1. Open the [Google Cloud Console](https://console.cloud.google.com).

2. Navigate to **Network Services** > **Cloud DNS** and select [**DNS Server Policies**](https://console.cloud.google.com/net-services/dns/policies).

3. Select **Create Policy**.

4. Provide a name for your Policy (such as `cloudflare-1-1-1-1`) and select associated VPC network or networks.

5. Under **Alternate DNS servers**, select **Add Item** and type:

   ```txt
   1.1.1.1
   1.0.0.1
   ```

6. Select **Create**.

DNS requests within the configured VPC network(s) will now use 1.1.1.1.
